dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua") -- "script_path" is main scripts folder. common is local.

local rate = 0.5
make_default_activity(rate) -- gets plane info

local Data = get_base_data() 

local dev = GetSelf()

function post_initialize()
    print("post_initialize called in Smoke.lua")
	smk_tog = false
	smoke_on = false
	deselect = false
	burnerLit = false 
	smoke_toggle_num = 0
	current_smoke = false
	smoke_armed = true --change to initially be false if you want to use the arming system
	center_smoke_equipped = false
	tip_smoke_equipped = false
	count = 0 --Will keep track of how long the burners are activated
	
	--Smokes equipable
	Smoke1 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}"
	Smoke2 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}"
	Smoke3 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}"
	Smoke4 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}"
	Smoke5 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}"
	Smoke6 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}"
end

--dev:listen_command(7003) -- Smoke Armed
dev:listen_command(7010)


function Logic()
	
	ST11 = dev:get_station_info(11)
	ST11CLSID = ST11.CLSID
	
	ST0 = dev:get_station_info(0)
	ST0CLSID = ST0.CLSID
	
	
	if((ST11CLSID == Smoke1) or (ST11CLSID == Smoke2) or (ST11CLSID == Smoke3) or (ST11CLSID == Smoke4) or (ST11CLSID == Smoke5) or (ST11CLSID == Smoke6)) then --If a smoke pod is on the smoke pylon
		center_smoke_equipped = true
	else
		center_smoke_equipped = false
	end
	
	if((ST0CLSID == Smoke1) or (ST0CLSID == Smoke2) or (ST0CLSID == Smoke3) or (ST0CLSID == Smoke4) or (ST0CLSID == Smoke5) or (ST0CLSID == Smoke6)) then --If a smoke pod is on the smoke pylon
		tip_smoke_equipped = true
	else
		tip_smoke_equipped = false
	end
	
	--[[ --Arming Smoke
	if get_cockpit_draw_argument_value(529) >= 1 then
		smoke_armed = true
	elseif get_cockpit_draw_argument_value(529) <= 1 then
		smoke_armed = false
		if smoke_on == true then
			if(center_smoke_equipped and tip_smoke_equipped) then
				dev:launch_station(0);
				dev:launch_station(8);
				dev:launch_station(11);
			elseif(center_smoke_equipped) then
				dev:launch_station(11);
			else
				dev:launch_station(0);
				dev:launch_station(8);
			end
			smoke_on = false
			print_message_to_user("Smoke Off")
		end
	end
	--]]
	
	BurnerState = get_cockpit_draw_argument_value(755) --Gets the value of the animation for the left afterburner
	--print_message_to_user(BurnerState)

	if BurnerState >= 0.606 then --If the left engine is in afterburner
		--print_message_to_user("Burners")
		count = count + 1
		if(count >= 4) then
			burnerLit = true 
		end
	elseif (count > 0) then --If the left engine is NOT in afterburner
		burnerLit = false
		count = 0
	end

	--If the left engine is in afterburner and the smoke is on the smoke will automatically be turned off.
	if burnerLit == true and smoke_on == true then 
		if(center_smoke_equipped and tip_smoke_equipped) then
			dev:launch_station(0);
			dev:launch_station(8);
			dev:launch_station(11);
		elseif(center_smoke_equipped) then
			dev:launch_station(11);
		else
			dev:launch_station(0);
			dev:launch_station(8);
		end
		smoke_on = false
		deselect = true --This variable is deselecting the smoke while in AB
	end

	--If the left engine is NOT in afterburner and the smoke has not been turned back on (from the if statement above) yet it will automatically be turned back on.
	if burnerLit == false and deselect == true then 
		if(center_smoke_equipped and tip_smoke_equipped) then
			dev:launch_station(0);
			dev:launch_station(8);
			dev:launch_station(11);
		elseif(center_smoke_equipped) then
			dev:launch_station(11);
		else
			dev:launch_station(0);
			dev:launch_station(8);
		end
		smoke_on = true
		deselect = false --This resets the value to default for the next AB selection
	end

	--If the smoke button has been pressed an odd number of times since the last update, or if the AB has been on since the last press the smoke will be toggled
	--IF AB is on nothing happens, and the toggle remains true so each update the AB state is checked again until the AB is deselected
	--This allows for you to toggle smoke while in AB without causing any smoke to be dispensed
	smoke_toggle = smoke_toggle_num % 2 -- this will either equal 1 or 0, if it equals 1 that means an odd number of presses has occured, and the next if statement will pass
	if smoke_toggle == 1 and smoke_armed == true then 
		if burnerLit == false then
			if(center_smoke_equipped and tip_smoke_equipped) then
				dev:launch_station(0);
				dev:launch_station(8);
				dev:launch_station(11);
			elseif(center_smoke_equipped) then
				dev:launch_station(11);
			else
				dev:launch_station(0);
				dev:launch_station(8);
			end
			--Resetting values for next presses
			smoke_toggle = 0
			smoke_toggle_num = 0
			if smoke_on == true then
				smoke_on = false
				print_message_to_user("Smoke Off")
			else --If the smoke is off
				smoke_on = true
				print_message_to_user("Smoke On")
			end
		else
			--Do nothing			
		end
	end
end


function SetCommand(command,value)
	
	if (command == 7010) and (center_smoke_equipped or tip_smoke_equipped) == true then --and track_is_reading() == false then
		smoke_toggle_num = smoke_toggle_num + 1  --Activates a variable to turn on or off smoke when appropriate once the smoke toggle has been pressed (keeps track of how many times the button is pressed).
	end
end

function update() -- Ties into "local rate" at top. Updates twice a second
Logic()
end

need_to_be_closed = false